function [col_array,noidx,bins] = collapse(array,col)
%This function will collapse an array generated by functions such as
%punc_distill along the column selected.  Collapsing means that along any
%column one value will be represented once in continum.
%Synatax:   [col_array] = collapse(array,col); 
%Input:     array = the array to be compressed
%           col = the column along which the compression will be determined
%               Default = 1.
%Output:    col_array = the collapsed array.
%           noidx = a logical array that is true where there is a value
%                   that is duplicated, thus removed.
%           bins = Each unique value is placed in a bin and the number of
%                   of time the value is present in the dataset is written
%                   on the bin.  So, the data is a 2 by x array, with the
%                   top row containing the unique value, and the 2nd row
%                   containing the frequency of appearance.

%set defaults
if nargin<2
    col = 1;        %column is 1 by default
end

cache = nan;         %initiate cache
j = 1;               %initiate collapsed array index
%freq = 1;            %initiate frequency counter
%preallocate
col_array = inf(size(array));
noidx = false(size(array,1),1);
bins = inf(2,size(array,1));
%sort the column just in case
col = sort(col);
for i = 1:size(array,1)
    if cache~=array(i,col)      %new value
        %write the previous value first
        if i~=1     %not the initalization phase of the loop
            bins(1,j) = cache;
            bins(2,j) = freq;
        end
        cache = array(i,col);   %cache the value
        col_array(j,:) = array(i,:);    %put the value into the collapsed array.
        j = j+1;
        freq = 1;       %reset
    else        %store the index of the values removed
        freq = freq+1;          %1 ahhh ha ha
        noidx(i) = 1;       %set the value to true
    end
end
%write out the last data point
bins(1,j) = cache;
bins(2,j) = freq;

%clean up extra space in col_array
col_array(isinf(col_array(:,col)),:) = [];
bins(:,isinf(bins(1,:))) = [];
    